IF EXISTS (SELECT * FROM SYS.procedures WHERE NAME = 'P_EST_NF_ENT_EFETUA_ENTRADA_NF_DEVO_ALL')
BEGIN
	DROP PROCEDURE P_EST_NF_ENT_EFETUA_ENTRADA_NF_DEVO_ALL
END
GO
--P_EST_NF_ENT_EFETUA_ENTRADA_NF_DEVO_ALL 1,999,406,'2015-12-29','2015-11-30',0
CREATE PROCEDURE P_EST_NF_ENT_EFETUA_ENTRADA_NF_DEVO_ALL (@CD_EMP INT, 
															 @CD_FILIAL INT, 
															 @CD_NT_MOV INT,
															 @DT_ENT DATETIME,
															 @DT_PROC DATETIME,
															 @CD_NF_SAI_PROC INT=0)
AS
begin
DECLARE @CD_NF INT
DECLARE @NR_NF INT
DECLARE @CONTADOR INT

DECLARE CnotasCplEntrada CURSOR FAST_FORWARD FOR 
	SELECT  DISTINCT TOP 1
			NF.CD_NF,
			NF.NF_NF
    FROM EST_NF_SAI NF INNER JOIN EST_NF_SAI_EST_NF_SAI_CPL C ON
			NF.CD_EMP			= C.CD_EMP AND
			NF.CD_FILIAL	= C.CD_FILIAL AND
			NF.CD_NF		= C.CD_NF	
			INNER JOIN EST_NF_SAI_NFE nfe ON
			NF.CD_EMP = nfe.CD_EMP AND
			NF.CD_FILIAL = nfe.CD_FILIAL AND
			NF.CD_NF = nfe.CD_NF 
	WHERE NF.CD_EMP = @CD_EMP
			AND NF.CD_FILIAL = @CD_FILIAL	
			AND NF.CD_NF = CASE WHEN @CD_NF_SAI_PROC= 0 THEN NF.CD_NF ELSE @CD_NF_SAI_PROC END
			AND NF.STS_NF=0	
			AND NF.DT_EMI_NF=@DT_PROC	
			AND NOT EXISTS (SELECT T.CD_EMP
							FROM EST_NF_ENT_EST_NF_SAI_TRANSF T 
							WHERE   T.CD_EMP			 = NF.CD_EMP
									AND T.CD_FIL_ORIG	 = NF.CD_FILIAL
									AND T.CD_NF_SAI		 = NF.CD_NF)
			AND NOT EXISTS (SELECT I.CD_EMP
							FROM EST_NF_SAI_EST_NF_NFE_INU I 
							WHERE   I.CD_EMP			 = NF.CD_EMP
									AND I.CD_FILIAL	 = NF.CD_FILIAL
									AND I.CD_NF		 = NF.CD_NF)
			AND NOT EXISTS (SELECT D.CD_EMP
							FROM EST_NF_SAI_NF_ENT D 
							WHERE   D.CD_EMP			 = NF.CD_EMP
									AND D.CD_FILIAL	 = NF.CD_FILIAL
									AND D.CD_NF_SAI		 = NF.CD_NF)
		ORDER BY
			NF_NF
SET @CONTADOR=1
OPEN CnotasCplEntrada
FETCH NEXT FROM CnotasCplEntrada INTO @CD_NF,@NR_NF
	WHILE @@FETCH_STATUS=0
	  begin
	  PRINT 'Nota Fiscal ' + CONVERT(VARCHAR, @NR_NF) + ' ' + CONVERT(VARCHAR, @CONTADOR) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
	    
		EXEC P_EST_NF_ENT_EFETUA_ENTRADA_NF_DEVO @CD_EMP,@CD_FILIAL,@CD_NT_MOV,@DT_ENT,@CD_NF,6

		SET @CONTADOR=@CONTADOR+1
	  FETCH NEXT FROM CnotasCplEntrada INTO @CD_NF,@NR_NF
	end
PRINT 'Concluido.'
CLOSE CnotasCplEntrada;
DEALLOCATE CnotasCplEntrada;
end